unit ucCustomers;

interface

uses
  SysUtils, System.Data, System.Drawing, System.Web, System.Web.UI,
  System.Text,   System.Web.UI.WebControls, System.Web.UI.HtmlControls, SmartDataGrid;

type
    /// <summary>
    /// Summary description for WebUserControl1.
    /// </summary>
  TucCustomers = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure dgCustomers_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    dlSubMenu: System.Web.UI.WebControls.DataList;
    ErrorMessage: System.Web.UI.WebControls.Label;
    dgCustomers: SmartDataGrid.TSmartDataGrid;
    procedure OnInit(e: System.EventArgs); override;
  private
  public
    { Public Declarations }
  end;

implementation

uses Helper, HelperDB;
 
procedure TucCustomers.Page_Load(sender: System.Object; e: System.EventArgs);
var
  selSQL : StringBuilder;
begin
  dlSubMenu.Visible := False;

	selSQL := StringBuilder.Create;
  selSQL.Append('SELECT * FROM Customers WHERE IsAdmin <> 1 OR IsAdmin IS NULL');


  dgCustomers.AutoGenerateColumns:=False;
  dgCustomers.PageSize:=15;
  dgCustomers.AllowPaging := True;

  dgCustomers.SelectSQL := selSQL.ToString;
  dgCustomers.DeleteSQL := 'DELETE FROM Customers WHERE CustomerID = ';

  dgCustomers.ErrorLabel := ErrorMessage;
  dgCustomers.DataKeyField := 'CustomerID';


  if not page.IsPostBack then dgCustomers.BindData;
end;

procedure TucCustomers.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);

end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucCustomers.InitializeComponent;
begin
  Include(Self.dgCustomers.UpdateCommand, Self.dgCustomers_UpdateCommand);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

  
procedure TucCustomers.dgCustomers_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  custid, name, email, pass : string;
begin
  custid := dgCustomers.DataKeys[e.Item.ItemIndex].ToString();
  name := TextBox(e.Item.FindControl('name')).Text;
  email := TextBox(e.Item.FindControl('email')).Text;
  pass := TextBox(e.Item.FindControl('pass')).Text;

  dgCustomers.UpdateSQL := 'UPDATE Customers SET FullName = ' + QuotedStr(Server.HtmlEncode(name)) +', EmailAddress = '+QuotedStr(email)+', Pass = '+QuotedStr(pass)+' Where CustomerID = ' + custid;
end;


end.
